//
//  MCShortcutGrabber.h
//  MCApplication
//
//  Created by Ali Lalani on 1/29/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//
/* Simple little panel/sheet that you can use to request a shortcut key combo from the user */

#import <Cocoa/Cocoa.h>
#import "MCWindowController.h"

@interface MCShortcutGrabber : MCWindowController {
	NSString *displayString;
	NSString *displayDescription;

	NSString *chars;
	unsigned int modifierFlags;
	unsigned short keyCode;

	id delegate;
}

- (IBAction)cancel:(id)sender;
- (IBAction)done:(id)sender;
- (IBAction)clear:(id)sender;

- (void)configureWithDictionary:(NSDictionary *)conf;
- (NSDictionary *)dictionaryRepresentation;

- (NSString *)displayString;
- (void)setDisplayString:(NSString *)aDisplayString;

- (NSString *)displayDescription;
- (void)setDisplayDescription:(NSString *)aDescription;

- (NSString *)chars;
- (void)setChars:(NSString *)aChars;

- (unsigned int)modifierFlags;
- (unsigned short)keyCode;

- (void)setDelegate:(id)del;
- (id)delegate;
@end

@interface NSObject (ShortcutGrabberDelegate)
- (BOOL)shortcutGrabber:(MCShortcutGrabber *)aGrabber shouldSetShortcutWithConfiguration:(NSDictionary *)config;
@end
